/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.udf;

import CH.ifa.draw.util.Storable;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.BlockParameter;
import DE.siemens.ad.logo.model.ParameterItem;
import DE.siemens.ad.logo.model.ParameterItemList;
import DE.siemens.ad.logo.model.ParameterItemValueFormatter;
import DE.siemens.ad.logo.util.ValueOrItemReference;
import DE.siemens.ad.udf.UDFBlock;
import DE.siemens.ad.udf.UDFParameterItem;
import java.io.IOException;
import java.util.Iterator;

public class UDFBlockParameter
extends BlockParameter {
    private static final long serialVersionUID = -114900134707695707L;
    private ParameterItemList itemList = new ParameterItemList(UDFBlock.class, 2);

    public UDFBlockParameter() {
    }

    public UDFBlockParameter(Block block) {
        super(block);
    }

    public void removeItem(String name) {
        Iterator iter = this.itemList.iterator();
        while (iter.hasNext()) {
            if (!((ParameterItem)iter.next()).getIdentifier().equals(name)) continue;
            iter.remove();
            break;
        }
    }

    public void removeAllItems() {
        this.itemList.clear();
    }

    public void addItem(String udfParameterIdenfier, Block referedBlock, String blockParamterIdentifier) {
        UDFParameterItem macroItem = new UDFParameterItem(this, udfParameterIdenfier, referedBlock.getParameter().getParameterItem(blockParamterIdentifier), this.itemList.size());
        this.itemList.add(macroItem);
    }

    public ParameterItem getParameterItem(String parameterItemIdentifier) {
        return this.itemList.getParameterItem(parameterItemIdentifier);
    }

    public ParameterItemList getParameterItems() {
        return this.itemList;
    }

    public String getParameterText() {
        StringBuffer result = new StringBuffer(46);
        StringBuffer enter = new StringBuffer("\n");
        StringBuffer equal = new StringBuffer(" = ");
        ParameterItemValueFormatter formatter = ParameterItemValueFormatter.getInstance();
        for (int i = 0; i < this.getParameterItems().size(); ++i) {
            UDFParameterItem item = (UDFParameterItem)this.getParameterItems().get(i);
            if (item.getParameterValueType() == 1) continue;
            if (item.getSourceParameterItem().getValue() instanceof ValueOrItemReference && ((ValueOrItemReference)item.getSourceParameterItem().getValue()).isReference()) {
                UDFBlock udf = (UDFBlock)this.getBlock();
                Block referBlk = ((ValueOrItemReference)item.getSourceParameterItem().getValue()).getReference().getParameter().getBlock();
                if (udf.getBlocks().contains(referBlk)) {
                    result.append(item.getIdentifier());
                    result.append(equal);
                    result.append(udf.getNumberPrefix() + "*");
                    result.append(enter);
                    continue;
                }
            }
            result.append(item.getIdentifier());
            result.append(equal);
            String value = formatter.formatUDF(item.getSourceParameterItem(), item.getSourceParameterItem().getValue());
            if (value == null || value.equals("")) continue;
            result.append(value);
            result.append(enter);
        }
        this.deleteLastEnter(result);
        return result.toString();
    }

    public String calculateCurrentParameterText() {
        StringBuffer text = new StringBuffer();
        ParameterItemValueFormatter formatter = ParameterItemValueFormatter.getInstance();
        for (int i = 0; i < this.itemList.size(); ++i) {
            String value;
            UDFParameterItem item = (UDFParameterItem)this.itemList.get(i);
            if (item.getParameterValueType() != 1 || (value = formatter.formatUDF(item.getSourceParameterItem(), item.getSourceParameterItem().getValue())) == null || value.trim().equals("")) continue;
            text.append(item.getIdentifier());
            text.append("=");
            text.append(value);
            text.append("\n");
        }
        this.deleteLastEnter(text);
        return text.toString();
    }

    private void deleteLastEnter(StringBuffer str) {
        if (str.length() > 0 && str.lastIndexOf("\n") == str.length() - 1) {
            str.deleteCharAt(str.lastIndexOf("\n"));
        }
    }

    public BlockParameter getSourceParam(String identifier) {
        for (int i = 0; i < this.itemList.size(); ++i) {
            UDFParameterItem item = (UDFParameterItem)this.itemList.get(i);
            if (item.getIdentifier().equals(identifier) && item.getSourceParameterItem().getParameter() instanceof BlockParameter) {
                return item.getSourceParameterItem().getParameter();
            }
            if (!item.getIdentifier().equals(identifier) || !(item.getSourceParameterItem().getParameter() instanceof UDFBlockParameter)) continue;
            return ((UDFBlockParameter)item.getSourceParameterItem().getParameter()).getSourceParam(identifier);
        }
        return null;
    }

    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeInt(this.itemList.size());
        for (Object obj : this.itemList) {
            dw.writeStorable((Storable)obj);
        }
    }

    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        int itemCount = dr.readInt();
        for (int i = 0; i < itemCount; ++i) {
            Storable macroPItem = dr.readStorable();
            this.itemList.add(macroPItem);
        }
    }

    public ParameterItemList getExposedParameterItems() {
        ParameterItemList ExposedItemList = new ParameterItemList(UDFBlock.class, 2);
        ParameterItemList itemList = this.getParameterItems();
        for (Object udfParamItem : itemList) {
            ParameterItem srcParamItem = ((UDFParameterItem)udfParamItem).getRootSourceParameterItem();
            if (srcParamItem.getParameterValueType() != 0) continue;
            Object paramValue = srcParamItem.getValue();
            if (paramValue instanceof ValueOrItemReference && ((ValueOrItemReference)paramValue).isReference()) {
                UDFBlock udf = (UDFBlock)this.getBlock();
                Block referBlk = ((ValueOrItemReference)paramValue).getReference().getParameter().getBlock();
                if (udf.getBlocks().contains(referBlk)) continue;
            }
            ExposedItemList.add(srcParamItem);
        }
        return ExposedItemList;
    }
}

